/**
* @fileOverview
* @description <span class="no_changes html_changes">taken 1:1 from existing eFiliale JavaScript,
*              only HTML/CSS output changes</span>
*/
/*
 * Javascript functions for captcha features.
 */
 // TODO INFOSYS changed URLs to absolute live path, so captcha would work in templates
function reloadCaptcha(reloadType) {
    if($('.captcha').attr('data-type') === "sound") {
        $('.captcha_content').html('<audio class="captcha__content--audio" type="audio/wav" src="/shop/security/captcha?captchaType=audio&random='
            + Math.random() + '" controls="true"> </audio>');
    } else if($('.captcha').attr('data-type') === "image") {
        $('.captcha_content').html('<img class="captcha__content--image" src="/shop/security/captcha?random=' + Math.random() + '&type=' + reloadType + '" border="0" />');
    }
}

$(document).ready(function () {
    $('.captcha__icon--image').hide();
     reloadCaptcha("refresh");
    $('.captcha__icon--reload').on('click', function(event) {
        reloadCaptcha("reload-" + event.type);
    });
    $('.captcha__icon--audio').on('click', function(event) {
        $('.captcha').attr('data-type','sound');
        $('.captcha__icon--audio').hide();
        $('.captcha__icon--image').show();
        reloadCaptcha("audio-" + event.type);
    });
    $('.captcha__icon--image').on('click', function(event) {
        $('.captcha').attr('data-type','image');
        $('.captcha__icon--image').hide();
        $('.captcha__icon--audio').show();
        reloadCaptcha("image-" + event.type);
    });
});
